#!/usr/bin/python

import sys
import math

# ------- vector functions -----------

# v0 + v1
def vec_add(v0, v1):
   return (v0[0]+v1[0], v0[1]+v1[1], v0[2]+v1[2])

# v0 - v1
def vec_subtract(v0, v1):
   return (v0[0]-v1[0], v0[1]-v1[1], v0[2]-v1[2])

# s * v0
def vec_scale(v0, s):
   return (s*v0[0], s*v0[1], s*v0[2])

# length v0
def vec_len(v0):
   return math.sqrt(v0[0]*v0[0] + v0[1]*v0[1] +v0[2]*v0[2])

# cross product v0xv1
def vec_cross(v0, v1):
	return (v1[2]*v0[1] - v1[1]*v0[2], v1[0]*v0[2] - v1[2]*v0[0], v1[1]*v0[0] - v1[0]*v0[1])

# scalar product v0.v1
def vec_scalar(v0, v1):
	return v0[0]*v1[0] + v0[1]*v1[1] + v0[2]*v1[2]

def get_rotation_matrix(a, v):
   v = vec_scale(v, 1.0/vec_len(v))
   
   m = [[0,0,0],[0,0,0],[0,0,0]]
   c = math.cos(a);
   s = math.sin(a);
   t = 1.0 - c;
   m[0][0] = c + v[0]*v[0]*t;
   m[1][1] = c + v[1]*v[1]*t;
   m[2][2] = c + v[2]*v[2]*t;


   tmp1 = v[0]*v[1]*t;
   tmp2 = v[2]*s;
   m[1][0] = tmp1 + tmp2;
   m[0][1] = tmp1 - tmp2;

   tmp1 = v[0]*v[2]*t;
   tmp2 = v[1]*s;
   m[2][0] = tmp1 - tmp2;
   m[0][2] = tmp1 + tmp2;

   tmp1 = v[1]*v[2]*t;
   tmp2 = v[0]*s;
   m[2][1] = tmp1 + tmp2;
   m[1][2] = tmp1 - tmp2;

   return m


def apply_rotation_matrix(m, v):

   new_v = [0, 0, 0]
   for i in range(3):
      for j in range(3):
         new_v[i] += m[i][j]*v[j]

   return new_v



def next_tet(tet, l, a):
   l -=1
   if l<0:
      return
   
   new_tet = tet[1:4]
   new_tet.append([])
   for i in range(3):
      new_tet[3].append( (2.0/3)*(tet[3][i]+tet[1][i]+tet[2][i]) - tet[0][i] )
   
   axis = vec_subtract(new_tet[3], tet[0])
   rot_mat = get_rotation_matrix(a, axis)
   for v in range(3):
      vec = vec_subtract(new_tet[v], tet[0])
      vec = apply_rotation_matrix(rot_mat, vec)
      new_tet[v] = vec_add(vec, tet[0])
   
   for v in new_tet:
      print "%g %g %g" % (v[0], v[1], v[2])

   next_tet(new_tet, l, a)


level = 2
if(len(sys.argv) > 1):
   level = int(sys.argv[1])

clock = 0
if(len(sys.argv) > 2):
   clock = float(sys.argv[2])

ang = clock*2*math.pi

num_tets = 1 + 12*level

print "OFF"
print "%d %d %d" % (4*num_tets, 4*num_tets, 6*num_tets)

tet = [[-1, 1, -1], [-1, -1, 1], [1, 1, 1], [1, -1, -1]]
for v in tet:
   print "%g %g %g" % (v[0], v[1], v[2])


tet_combs = []
for i in range(4):
   if i%2:
      tet_combs.append([(0+i)%4, (1+i)%4, (2+i)%4, (3+i)%4])
      tet_combs.append([(0+i)%4, (2+i)%4, (3+i)%4, (1+i)%4])
      tet_combs.append([(0+i)%4, (3+i)%4, (1+i)%4, (2+i)%4])
   else:
      tet_combs.append([(0+i)%4, (1+i)%4, (3+i)%4, (2+i)%4])
      tet_combs.append([(0+i)%4, (2+i)%4, (1+i)%4, (3+i)%4])
      tet_combs.append([(0+i)%4, (3+i)%4, (2+i)%4, (1+i)%4])

for comb in tet_combs:
   tet_c=[tet[comb[i]] for i in range(4)]
   next_tet(tet_c, level, ang)

for i in range(num_tets):
   for verts in [(0,1,2), (1,2,3), (2,3,0), (3,0,1)]:
      print "3 %d %d %d" % (i*4+verts[0], i*4+verts[1], i*4+verts[2])


