#!/usr/bin/python

import sys

def print_oct_verts(tet):
   for v1 in range(3):
      for v2 in range(v1+1, 4):
         for i in range(3):
            #print "%d=%g %d=%g" % (v1, tet[v1][i], v2, tet[v2][i])
            print "%g " % ( float(tet[v1][i] + tet[v2][i])/2.0 ),
         print
         
   

def next_tets(tet, l, num_faces):
   l -=1
   if l<0:
      return

   
   verts = [(3,0,1,2), (1,2,3,0), (2,3,0,1)]
   if num_faces==4:
      verts.append((0,1,2,3))
         
   for vs in verts:
      new_tet = [[],[],[],[]]
      for i in range(3):
         new_tet[0].append((tet[vs[0]][i]+tet[vs[1]][i])/2.0)
         new_tet[1].append((tet[vs[1]][i]+tet[vs[2]][i])/2.0)
         new_tet[2].append((tet[vs[2]][i]+tet[vs[0]][i])/2.0)
         new_tet[3].append((tet[vs[0]][i]+tet[vs[1]][i]+tet[vs[2]][i] - tet[vs[3]][i])/2.0)
      
      print_oct_verts(new_tet)

      next_tets(new_tet, l, 3)

   for vs in range(4):
      new_tet = [[],[],[],[]]
      for i in range(3):
         new_tet[0].append((tet[vs][i]+tet[(vs+1)%4][i])/2.0)
         new_tet[1].append((tet[vs][i]+tet[(vs+2)%4][i])/2.0)
         new_tet[2].append((tet[vs][i]+tet[(vs+3)%4][i])/2.0)
         new_tet[3].append(tet[vs][i])
      
      print_oct_verts(new_tet)

      next_tets(new_tet, l, 3)


level = 2
if(len(sys.argv) > 1):
   level = int(sys.argv[1])

num_tets = 1
for i in range(level):
   num_tets += 8*7**i

print "OFF"
print "%d %d %d" % (6*num_tets, 8*num_tets, 12*num_tets)

tet = [[-1, 1, -1], [-1, -1, 1], [1, 1, 1], [1, -1, -1]]
print_oct_verts(tet)

next_tets(tet, level, 4)

for i in range(num_tets):
   for verts in [(0,1,2), (0,2,4), (2,1,5), (1,0,4), (3,4,5), (5,4,2), (4,3,0), (3,5,1)]:
      print "3 %d %d %d" % (i*6+verts[0], i*6+verts[1], i*6+verts[2])


