#!/usr/bin/python

import sys

steps = 3
if(len(sys.argv) > 1):
   steps = int(sys.argv[1])

num_faces = 6*((2*steps+1)**2 - 2*steps*(steps+1))

print "OFF"
print "%d %d %d" % (4*num_faces, num_faces, 4*num_faces)

def add_faces(i, j, steps):
   st = float(steps)
   step = abs(i)
   if abs(j)>abs(i):
      step = abs(j)
   k = steps - step
   #print"                  %d  %d  %d\n" %(i, j, k)
   for coord in [[0, 1, 2], [1, 2, 0], [2, 0, 1]]:
      for z_sign in [1, -1]:
         for off in [[-1,1], [1,1], [1,-1], [-1,-1]]:
            v=[x/(2*st+1) for x in [i+off[0]/2.0, j+off[1]/2.0, z_sign*(k+0.5)]]
            print "%g %g %g" % (v[coord[0]], v[coord[1]], v[coord[2]])
   

for i in range(-steps, steps+1):
   for j in range(-steps, steps+1):
      if steps >= abs(i)+abs(j):
         add_faces(i, j, steps)
      

for face in range(num_faces):
   f = face*4
   print "4 %d %d %d %d" % (f, f+1, f+2, f+3)


